/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.util.Vector;
import jclass.bwt.JCSerializable;
import jclass.chart.Chartable;
import jclass.util.JCVector;

public class InputStreamDataSource
implements Chartable,
JCSerializable {
    private StreamTokenizer tokenizer;
    private Vector data = new Vector();
    private int dataInterpretation;
    private String name;
    private Vector seriesNames = new Vector();
    private Vector pointLabels = new Vector();
    private double holeValue;
    private final char QUOTE = (char)39;
    static final int PARSE_ERR_DATA_STYLE = 1;
    static final int PARSE_ERR_HOLE_OR_VALUE = 2;
    static final int PARSE_ERR_POINT_LABEL = 3;

    public InputStreamDataSource(InputStream inputStream) throws IOException {
        this.ctor(inputStream);
    }

    protected InputStreamDataSource() {
    }

    protected void ctor(InputStream inputStream) throws IOException {
        this.tokenizer = new StreamTokenizer(inputStream);
        this.tokenizer.commentChar(35);
        this.tokenizer.quoteChar(39);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.lowerCaseMode(true);
        this.tokenizer.parseNumbers();
        this.tokenizer.whitespaceChars(43, 43);
        this.init();
        this.tokenizer = null;
    }

    private double getNextDouble() throws IOException {
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != -2) {
            String string;
            if (this.tokenizer.ttype == -3 && (string = this.tokenizer.sval).equalsIgnoreCase("HOLE")) {
                return Double.MAX_VALUE;
            }
            this.displayErrorMessage(2);
            throw new IOException("Error in data file format - " + this.tokenizer);
        }
        if (this.holeValue != 0.0 && this.tokenizer.nval == this.holeValue) {
            return Double.MAX_VALUE;
        }
        double d = this.tokenizer.nval;
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype == -3 && this.tokenizer.sval != null && (this.tokenizer.sval.charAt(0) == 'e' || this.tokenizer.sval.charAt(0) == 'E')) {
            if (this.tokenizer.sval.length() == 1) {
                this.tokenizer.nextToken();
                if (this.tokenizer.ttype == -2) {
                    d *= Math.pow(10.0, this.tokenizer.nval);
                }
            } else {
                int n = Integer.valueOf(this.tokenizer.sval.substring(1));
                d *= Math.pow(10.0, n);
            }
        } else {
            this.tokenizer.pushBack();
        }
        return d;
    }

    private void displayErrorMessage(int n) {
        boolean bl = true;
        String string = "Error reading data: line " + this.tokenizer.lineno() + ": ";
        switch (n) {
            case 1: {
                string = String.valueOf(string) + "Data must start with ARRAY or GENERAL and not ";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "Expect either a hole or numeric value and not ";
                break;
            }
            case 3: {
                string = String.valueOf(string) + "Expect a point label and not ";
                break;
            }
            default: {
                return;
            }
        }
        if (bl) {
            string = this.tokenizer.ttype == 39 ? String.valueOf(string) + "'" + this.tokenizer.sval + "'" : (this.tokenizer.ttype == -3 ? String.valueOf(string) + this.tokenizer.sval : (this.tokenizer.ttype == -2 ? String.valueOf(string) + this.tokenizer.nval : String.valueOf(string) + this.tokenizer.toString()));
        }
        System.err.println(string);
    }

    private synchronized void init() throws IOException {
        boolean bl;
        if (this.tokenizer.nextToken() != -3 || !this.tokenizer.sval.equals("array") && !this.tokenizer.sval.equals("general")) {
            this.displayErrorMessage(1);
            throw new IOException("Data must start with ARRAY or GENERAL");
        }
        this.dataInterpretation = this.tokenizer.sval.equals("array") ? 0 : 1;
        if (this.tokenizer.nextToken() == 39) {
            this.name = new String(this.tokenizer.sval);
        } else {
            this.tokenizer.pushBack();
        }
        int n = (int)this.getNextDouble();
        int n2 = (int)this.getNextDouble();
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equals("t")) {
            bl = true;
        } else {
            bl = false;
            this.tokenizer.pushBack();
        }
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equals("hole")) {
            this.holeValue = this.getNextDouble();
        } else {
            this.tokenizer.pushBack();
        }
        switch (this.dataInterpretation) {
            case 0: {
                this.readArrayData(n, n2, bl);
                return;
            }
            case 1: {
                this.readGeneralData(n, n2, bl);
                return;
            }
        }
    }

    private void readArrayData(int n, int n2, boolean bl) throws IOException {
        if (bl) {
            int n3;
            Double[][] doubleArray = new Double[n + 1][n2];
            int n4 = 0;
            while (n4 < n + 1) {
                if (this.tokenizer.nextToken() != 39) {
                    this.tokenizer.pushBack();
                    break;
                }
                this.seriesNames.addElement(new String(this.tokenizer.sval));
                ++n4;
            }
            n4 = 0;
            while (n4 < n2) {
                if (this.tokenizer.nextToken() == 39) {
                    this.pointLabels.addElement(new String(this.tokenizer.sval));
                } else {
                    this.pointLabels.addElement("");
                    this.tokenizer.pushBack();
                }
                n3 = 0;
                while (n3 < n + 1) {
                    doubleArray[n3][n4] = new Double(this.getNextDouble());
                    ++n3;
                }
                ++n4;
            }
            n3 = 0;
            while (n3 < n + 1) {
                JCVector jCVector = new JCVector(doubleArray[n3]);
                this.data.addElement(jCVector);
                ++n3;
            }
        } else {
            Vector<Double> vector = null;
            int n5 = 0;
            while (n5 < n2) {
                if (this.tokenizer.nextToken() != 39) {
                    if (n5 == 0) {
                        this.tokenizer.pushBack();
                        this.pointLabels = null;
                        break;
                    }
                    this.displayErrorMessage(3);
                    throw new IOException("Error in reading point labels - " + this.tokenizer);
                }
                this.pointLabels.addElement(new String(this.tokenizer.sval));
                ++n5;
            }
            int n6 = 0;
            while (n6 < n + 1) {
                if (this.tokenizer.nextToken() == 39) {
                    this.seriesNames.addElement(new String(this.tokenizer.sval));
                } else {
                    this.seriesNames.addElement("");
                    this.tokenizer.pushBack();
                }
                vector = new Vector<Double>();
                n5 = 0;
                while (n5 < n2) {
                    vector.addElement(new Double(this.getNextDouble()));
                    ++n5;
                }
                this.data.addElement(vector);
                ++n6;
            }
        }
        if (this.seriesNames.size() > 0) {
            this.seriesNames.removeElementAt(0);
        }
    }

    private void readGeneralData(int n, int n2, boolean bl) throws IOException {
        int n3;
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equals("labels")) {
            n3 = 0;
            while (n3 < n2) {
                if (this.tokenizer.nextToken() != 39) {
                    this.displayErrorMessage(3);
                    throw new IOException("Error in reading point labels - " + this.tokenizer);
                }
                this.pointLabels.addElement(this.tokenizer.sval);
                ++n3;
            }
        } else {
            this.tokenizer.pushBack();
            this.pointLabels = null;
        }
        if (bl) {
            int n4 = 0;
            while (n4 < n) {
                if (this.tokenizer.nextToken() == 39) {
                    this.seriesNames.addElement(new String(this.tokenizer.sval));
                } else {
                    this.tokenizer.pushBack();
                }
                n2 = (int)this.getNextDouble();
                Object[] objectArray = new Double[n2];
                Object[] objectArray2 = new Double[n2];
                int n5 = 0;
                while (n5 < n2) {
                    objectArray[n5] = new Double(this.getNextDouble());
                    objectArray2[n5] = new Double(this.getNextDouble());
                    ++n5;
                }
                JCVector jCVector = new JCVector(objectArray);
                this.data.addElement(jCVector);
                jCVector = new JCVector(objectArray2);
                this.data.addElement(jCVector);
                ++n4;
            }
            return;
        }
        int n6 = 0;
        while (n6 < n) {
            if (this.tokenizer.nextToken() == 39) {
                this.seriesNames.addElement(new String(this.tokenizer.sval));
            } else {
                this.tokenizer.pushBack();
            }
            n2 = (int)this.getNextDouble();
            n3 = 0;
            while (n3 < 2) {
                Vector<Double> vector = new Vector<Double>();
                int n7 = 0;
                while (n7 < n2) {
                    vector.addElement(new Double(this.getNextDouble()));
                    ++n7;
                }
                this.data.addElement(vector);
                ++n3;
            }
            ++n6;
        }
    }

    public int getDataInterpretation() {
        return this.dataInterpretation;
    }

    public synchronized Object getDataItem(int n, int n2) {
        Vector vector = (Vector)this.data.elementAt(n);
        return vector.elementAt(n2);
    }

    public synchronized Vector getRow(int n) {
        return (Vector)this.data.elementAt(n);
    }

    public int getNumRows() {
        return this.data.size();
    }

    public String[] getPointLabels() {
        if (this.pointLabels == null) {
            return null;
        }
        Object[] objectArray = new String[this.pointLabels.size()];
        this.pointLabels.copyInto(objectArray);
        return objectArray;
    }

    public String getSeriesName(int n) {
        String string;
        try {
            string = (String)this.seriesNames.elementAt(n);
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String getSeriesLabel(int n) {
        String string;
        try {
            string = (String)this.seriesNames.elementAt(n);
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String getName() {
        return this.name;
    }
}

